#version 330 core

layout(location = 0) in vec3 attribute_position;
layout(location = 1) in vec3 attribute_normal;
layout(location = 2) in vec2 attribute_uv;

out vec3 vertex_position;
out vec3 vertex_normal;
out vec2 vertex_uv;

uniform mat4 view_to_clip;
uniform mat4 model_to_view;
uniform mat4 normal_transform;

void main()
{
    gl_Position = view_to_clip * model_to_view * vec4(attribute_position, 1.0f);

    vec4 temp_pos = model_to_view * vec4(attribute_position, 1.0);
    vertex_position = vec3(temp_pos) / temp_pos.w;

    vertex_normal = vec3(normal_transform * vec4(attribute_normal, 0.0));

    vertex_uv = attribute_uv;
}
